package MusicLandscape.util.matcher;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyRangeMatcher;

/**
 * Encapsulates the concept of matching a track based on its duration.
 * <p>
 * This class is used to test whether given a given track's duration lies in a certain range, the range being the
 * pattern of this matcher.The pattern is a simple string consisting of the (white-space separated) lower and upper
 * bounds (inclusive) of the range of duration s (in seconds) accepted by this matcher.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 2
 * @since ExerciseSheet05
 */
public class DurationMatcher extends MyRangeMatcher<Track> {
    /**
     * Creates a default duration matcher.<br>
     * By default, a matcher matches any duration, including unknown duration.
     */
    public DurationMatcher() {
        this("");
    }

    /**
     * Creates a duration matcher with a specified pattern.
     *
     * @param pat the pattern of this matcher
     */
    public DurationMatcher(String pat) {
        super(pat);
    }

    /**
     * A track matches if its duration is in the range accepted by this matcher.
     *
     * @param track the object to match
     * @return whether t matches the pattern of this matcher.
     */
    @Override
    public boolean matches(Track track) {
        return track.getDuration() >= lower && track.getDuration() <= upper;
    }

    /**
     * the string representation is duration in range (RANGE)<br>
     * with range as described in getPattern
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "duration in range (" + lower + " " + upper + ")";
    }

    /**
     * We have to redeclare the bounds fields because the DurationMatcherTest is brittle.<br>
     * Lower bound for matched range.
     */
    protected int lower;

    /**
     * We have to redeclare the bounds fields because the DurationMatcherTest is brittle.<br>
     * Upper bound for matched range.
     */
    protected int upper;

    /**
     * We have to override this method because the DurationMatcherTest is brittle.<br>
     * Sets the pattern of this matcher.
     * <p>
     * Interprets the argument as described in the class documentation. First sets the lower, then the upper bound.
     * The bounds specified are set if and only if at the time of setting they are actually lower (for the lower bound)
     * or higher (for the upper bound) than the other or at least equal to the other.
     *
     * @param pat the pattern to set
     */
    @Override
    public void setPattern(String pat) {
        super.setPattern(pat);
        lower = super.lower;
        upper = super.upper;
    }
}
